/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.log;

import java.io.Serializable;

public class LogAttributes
implements Serializable {
    public static final boolean ERROR = true;
    public static final boolean INFO = false;
    public static final boolean STANDARD_BLOCK = true;
    public static final boolean OMIT_STANDARD_BLOCK = false;
    public static final boolean HARDWARE_BLOCK = true;
    public static final boolean OMIT_HARDWARE_BLOCK = false;
    public static final boolean MODIFY_BLOCK = true;
    public static final boolean OMIT_MODIFY_BLOCK = false;
    public static final boolean DISPLAY_AS_ERROR = true;
    public static final boolean DISPLAY_AS_INFO = false;
    public static final LogAttributes ERROR_LOG = new LogAttributes(true, true, false, false, true);
    public static final LogAttributes INFO_LOG = new LogAttributes(false, true, false, false, false);
    public static final LogAttributes DEFAULT = new LogAttributes(false, false, false, false, false);
    private static final short ERROR_ATTR = 1;
    private static final short STANDARD_BLOCK_ATTR = 2;
    private static final short MODIFY_BLOCK_ATTR = 4;
    private static final short DISPLAY_AS_ERROR_ATTR = 8;
    private static final short HARDWARE_BLOCK_ATTR = 4096;
    protected short attribs_ = 0;

    public LogAttributes(boolean error, boolean standardLogBlock, boolean modifyLogBlock, boolean displayAsError) {
        if (error) {
            this.attribs_ = (short)(this.attribs_ | 1);
        }
        if (standardLogBlock) {
            this.attribs_ = (short)(this.attribs_ | 2);
        }
        if (modifyLogBlock) {
            this.attribs_ = (short)(this.attribs_ | 4);
        }
        if (displayAsError) {
            this.attribs_ = (short)(this.attribs_ | 8);
        }
    }

    public LogAttributes(boolean error, boolean standardLogBlock, boolean hardwareLogBlock, boolean modifyLogBlock, boolean displayAsError) {
        if (error) {
            this.attribs_ = (short)(this.attribs_ | 1);
        }
        if (standardLogBlock) {
            this.attribs_ = (short)(this.attribs_ | 2);
        }
        if (hardwareLogBlock) {
            this.attribs_ = (short)(this.attribs_ | 0x1000);
        }
        if (modifyLogBlock) {
            this.attribs_ = (short)(this.attribs_ | 4);
        }
        if (displayAsError) {
            this.attribs_ = (short)(this.attribs_ | 8);
        }
    }

    public LogAttributes() {
        this(false, false, false, false, false);
    }

    public boolean isError() {
        return (this.attribs_ & 1) != 0;
    }

    public boolean isStandardBlock() {
        return (this.attribs_ & 2) != 0;
    }

    public boolean isHardwareBlock() {
        return (this.attribs_ & 0x1000) != 0;
    }

    public boolean isModifyBlock() {
        return (this.attribs_ & 4) != 0;
    }

    public boolean isDisplayAsError() {
        return (this.attribs_ & 8) != 0;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.getClass().getName()).append("@").append(this.hashCode()).append(this.isError() ? "[Error" : "[Info").append(this.isStandardBlock() ? ",Std" : ",~Std").append(this.isModifyBlock() ? ",Mod" : ",~Mod").append(this.isDisplayAsError() ? ",Err]" : ",~Err]");
        return result.toString();
    }
}

